﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/private/Private.Master" CodeBehind="fichaservidores.aspx.vb" Inherits="Web.fichaservidores" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <asp:UpdatePanel runat="server" ID="UpdatePanelRegistration" UpdateMode="Conditional">
        <ContentTemplate>

            <div class="block private">
                <div class="add-panel">
                    <div class="container newpanels">
                        <h2><%= Translator.Translate("ADMIN_SERVER_NEW")%></h2>
                    </div>
                </div>
                <div class="content ajax-tabs">

                    <div class="reg-form" runat="server" id="DivCamps">

                        <fieldset>
                            <div class="row private" runat="server" id="divEtiqueta">
                                <span class="label"><%= Translator.Translate("ADMIN_SERVER_LABEL")%> </span>
                                <asp:TextBox ID="Etiqueta" runat="server" CssClass="input" Text=""></asp:TextBox>
                            </div>
                            <div class="row private">
                                <span class="label"><%= Translator.Translate("ADMIN_SERVER_IP")%> </span>
                                <asp:TextBox ID="IP" runat="server" CssClass="input" Text=""></asp:TextBox>
                            </div>
                            <div class="row private">
                                <span class="label"><%= Translator.Translate("ADMIN_SERVER_PORT")%> </span>
                                <asp:TextBox ID="Puerto" runat="server" CssClass="input" Text="" Width="120px"></asp:TextBox>
                            </div>
                            <div class="row private" runat="server" id="divCodigoServidor">
                                <span class="label"><%= Translator.Translate("ADMIN_SERVER_CODE")%> </span>
                                <asp:TextBox ID="CodigoServidor" runat="server" CssClass="input readonly" Text="" ReadOnly="true"></asp:TextBox>
                            </div>
                            <div class="row private" runat="server" id="divZona">
                                <asp:Label ID="lblIdZona" runat="server" CssClass="label" Width="80px"></asp:Label>
                                <asp:DropDownList ID="IdZona" runat="server" CssClass="input"></asp:DropDownList>
                            </div>

                            <div class="row" runat="server" id="divProbarConectividad">
                                <br />
                                <asp:Button ID="btnProbarConectividad" runat="server" CssClass="btn" Width="160" />
                                <span class="<%=CssEstadoServidor%>"></span>
                                <asp:Literal ID="litVersion" runat="server"></asp:Literal>
                            </div>
                            <div class="row">
                                <br />
                                <asp:Button ID="btnGuardar" runat="server" CssClass="btn" />
                                <asp:Button ID="btnEsborrar" runat="server" CssClass="btn" Visible="false" />
                                <asp:Button ID="btnCancelar" runat="server" CssClass="btn" Style="float: right;" />
                            </div>
                            <div class="row">
                                <br />
                            </div>
                        </fieldset>

                        <!-- controles ocultos-->
                        <asp:HiddenField ID="IdCliente" runat="server" />
                        <asp:HiddenField ID="FechaActivacion" runat="server" />
                        <asp:HiddenField ID="FechaUltimaConexion" runat="server" Value="#null#" />

                    </div>

                    <!--Panel de errores del formulario de registro -->
                    <asp:Panel ID="PanelErrores" runat="server" Style="display: none" CssClass="error-message">
                        <div class="holder">
                            <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
                            <asp:Button ID="btnAceptar_Esborrar" runat="server" Visible="false" />
                            <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn"></a>
                        </div>
                    </asp:Panel>

                </div>

            </div>

            <!-- controles ajax-->
            <ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID="" />

            <!-- controles ocultos-->
            <asp:HiddenField ID="hdnPanelErrores" runat="server" />

        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="btnGuardar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="btnCancelar" EventName="Click" />
        </Triggers>
    </asp:UpdatePanel>
    <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderRegistration" TargetControlID="UpdatePanelRegistration" BehaviorID="animation" runat="server">
        <Animations>    
            <OnUpdated>
                <Sequence>
                    <FadeIn AnimationTarget="PanelErrores" Duration="0.15" minimumOpacity=".3"  />
                    <EnableAction AnimationTarget="btnCancelar_PanelErrores" Enabled="true" />
                    <ScriptAction Script="initRefreshFunctions();" />
                </Sequence>
            </OnUpdated>
        </Animations>
    </ajaxToolkit:UpdatePanelAnimationExtender>

</asp:Content>
